/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: OmbOmbTask_Functionlist.h 4762 2016-02-17 08:27:17Z iborisov $:
Description:
Omb Task
Includes following functions...
**************************************************************************************/

/**
 * @file OmbOmbTask_Functionlist.h
 * @brief Omb OmbTask - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_OmbOmbTask</code>
 * of task.
 */
#ifndef __OMB_OMBTASK_FUNCTIONLIST_H
#define __OMB_OMBTASK_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_OmbOmbTask
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskLeave_OmbOmbTask
(
 TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);

TLR_VOID
TaskEnter_OmbOmbTask
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define OMB_OMBTASK_STARTUP_PARAM_VERSION_4   (4)


/** Limits, bitsmasks of the startup parameter */

/*** Queue, pool element sizes ***/
/* Min/Default/Max OMB tasks process queue size for AP packets (ulQueElemCnt) */
#define OMB_SRT_QUE_ELEM_CNT_MIN              (16)    /* 1 per socket         */
#define OMB_SRT_QUE_ELEM_CNT_DEFAULT          (256)   /* Choose value bigger  */
                        /* than sum of our pool size and the sizes of other   */
                        /* pools (TCP_UDP task = 64, AP task = 32) ==> > 128  */
                        /* (Avoid queue overflow)                             */
#define OMB_SRT_QUE_ELEM_CNT_MAX              (16384) /* 64 times of _DEFAULT */

/* Min/Default/Max pool element count (ulPoolElemCnt)                         */
#define OMB_SRT_POOL_ELEM_CNT_MIN             (48)    /* 3 per socket         */
#define OMB_SRT_POOL_ELEM_CNT_DEFAULT         (64)    /* Suggestion: 4 per    */
                                                      /* socket               */
#define OMB_SRT_POOL_ELEM_CNT_MAX             (2048)  /* 64 times of _DEFAULT */
                        /* For a config reload with 16 server sockets, we need*/
                        /* the following resources from pool: 16 wait open, 1 */
                        /* IP set config and 16 close socket ==> > 33!        */


/*** OMB task configuration ***/
/* Start flags (ulStartFlags) */
#define OMB_SRT_FLAG_NONE                     (0x00000000L) /* Default value  */
      /* for no start flags defined                                           */
#define OMB_SRT_FLAG_ENABLE_RANGE             (0x00000001L)
      /* If this flag is set, the Data range is limited and ulMaxRegsCnt      */
      /* and ulMaxCoilsCnt are handled                                        */
#define OMB_SRT_FLAG_ENABLE_TCP_TASK_SEARCH   (0x00000002L)
      /* If this falg is set, the OMB task will search for the TCPIP also on  */
      /* instance 0..6 and not only on the same instance like the OMB task    */
      /* This flag should be set only in special cases when the TCP task is   */
      /* not placed on same instance like the OMB task. Normaly the TCP task  */
      /* should have the same instance like the OMB task.                     */
#define OMB_SRT_FLAG_ENABLE_TCPIP_NO_CONFIG   (0x00000004L)
      /* If this flag is set, the OMB task is forced not to initialize the    */
      /* TCP IP task. e.g. an other application is responseable for TCP cfg.  */
#define OMB_SRT_FLAG_RESERVED                 (0xFFFFFFF8L)
      /* !!Add new flags also by startup-parameter check in module            */
      /* xx_Resources.c, function xx_InitLocal()!!                            */
      /* and modify the reserved falg field                                   */

/* Min/Default/Max Cycletime of OMB task in ms (ulOmbCycleEvent)              */
#define OMB_SRT_OMB_CYCLE_EVENT_MIN           (10)
#define OMB_SRT_OMB_CYCLE_EVENT_DEFAULT       (10)  /* Suggestion: 50 ms      */
                        /* Value from Ombtask.c, RcsSetEventCycle()           */
#define OMB_SRT_OMB_CYCLE_EVENT_MAX           (200) /*                        */


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct OMB_OMBTASK_STARTUPPARAMETER_Ttag  OMB_OMBTASK_STARTUPPARAMETER_T;

/* */
typedef struct OMB_OMBTASK_UESR_SPECIFIC_ID_Ttag

{
  TLR_UINT32 ulObjectID;
  TLR_CHAR *szValue;

}OMB_OMBTASK_UESR_SPECIFIC_ID_T;

/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct OMB_OMBTASK_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;

  /* -------------------------------------------------------------------------- */
  /* OMB_STARTUPPARAMETER_VERSION 1   (OMB task version V02.000)                */
  /* -------------------------------------------------------------------------- */

  /*** Queue, pool element sizes ***/
  TLR_UINT32  ulQueElemCnt;         /* OMB tasks process queue size                       */
                                    /* Range: OMB_SRT_QUE_ELEM_CNT_MIN ...                */
                                    /*        OMB_SRT_QUE_ELEM_CNT_MAX                    */

  TLR_UINT32  ulPoolElemCnt;        /* Size of pool elements for indication packets       */
                                    /* to AP. One pool element allocates (approx.) 1524   */
                                    /* bytes                                              */
                                    /* Range: OMB_SRT_POOL_ELEM_CNT_MIN  ...              */
                                    /*        OMB_SRT_POOL_ELEM_CNT_MAX                   */

  /*** OMB Task configuration ***/
  TLR_UINT32  ulStartFlags;         /* Start flags (see OMB_SRT_FLAG_xx above)            */

  TLR_UINT32  ulOmbCycleEvent;      /* Cycletime of OMB task in ms - call                 */
                                    /* intervall of cyclic functions                      */
                                    /* Must be greater or equal the OS cycletime          */
                                    /* ptRsc->tLoc.ulTcpOsCycleTime!                      */
                                    /* Range: OMB_SRT_OMB_CYCLE_EVENT_MIN ...             */
                                    /*        OMB_SRT_OMB_CYCLE_EVENT_MAX                 */

  TLR_UINT32  ulMaxRegsCnt;         /* Determinate the max register, which can be accessed */
  TLR_UINT32  ulMaxCoilsCnt;        /* Determinate the max register, which can be accessed */

  /* User Identification Objects - FC43 */
  TLR_UINT32  ulNumOfObj;
  OMB_OMBTASK_UESR_SPECIFIC_ID_T *ptObjList;
};


/*************************************************************************************/
#endif /* #ifndef __OMB_OMBTASK_FUNCTIONLIST_H */
